<?php

	/**
	 * (./) process.php
	 * (by) cousot stéphane @ http://www.ubaa.net/
	 * (cc) some right reserved
	 *
	 * User request's dispatcher, backend process.
	 * 
	 *
	 * ---------------------------------------------------------------------------------------------
	 *
	 *  THIS CODE ARE RELEASED UNDER A CREATIVE COMMONS ATTRIBUTION 4.0 INTERNATIONAL LICENSE
	 *  @ http://creativecommons.org/licenses/by/4.0/
	 *
	 * ---------------------------------------------------------------------------------------------
	 */



	// config file(s)
	define( "USER_CONFIG",    "/boot/settings.txt" );
	define( "DEFAULT_CONFIG", "/srv/http/conf/default" );
	define( "DEFAULT_SCRIPT", "/srv/http/conf/script" );

	// path(s)
	define( "PREVIEW_PATH",   "/img/preview.jpg" );

	// script(s)
	define( "STREAM_SCRIPT", "/boot/live-stream" );
	define( "CONFIG_SCRIPT", "/root/bin/setup.sh" );

	// systemd servive(s)
	define( "STREAM_SERVICE", "piview-livestream" );


	# handle reboot 
	if ( $_SERVER['REQUEST_METHOD']==='HEAD' ) die;

	// handle redirections / requests
	if ( $_SERVER['REDIRECT_STATUS']=="404" ) {
		$what = trim( $_SERVER['REQUEST_URI'], '/' );
		if ( $what=="start" || $what=="stop" || $what=="restart" ) do_service( $what );
		else if ( $what=="poster" || $what=="preview" ) header( "location: ".PREVIEW_PATH );
		else header("${_SERVER['SERVER_PROTOCOL']} 404 Not Found");
		die;
	}

	# accept only POST from host referer
	# or respond with a 403 status code
	if ( !$_POST || !preg_match("/^http:\/\/${_SERVER['HTTP_HOST']}\//", $_SERVER["HTTP_REFERER"]) )
	{
		header("${_SERVER['SERVER_PROTOCOL']} 403 Forbidden");
		die;
	}


	# dispatch
	header('Content-Type: text/plain; charset=utf-8');
	switch( $_POST['do'] )
	{
		case 'config'	: do_config($_POST['action']); break;
		case 'script'	: do_script($_POST['action']); break;
		case 'log'		: do_log(); break;
		case 'service'	: do_service($_POST['ctl']); break;
		case 'netinfo'	: do_netinfo(); break;
		case 'exec'		: do_exec($_POST['cmd'],$_POST['quiet']); break;
		case 'sysinfo'	: do_sysinfo(); break;
		case 'update'	: system( "sudo ".CONFIG_SCRIPT." --update" ); break;
		case 'reboot'	: do_reboot(); break;
		case 'shutdown' : do_shutdown(); break;
		
		default: break;
	}


	# ------------------------------------------------------------------------------------------------------------------
	# 	CONFIG
	# ------------------------------------------------------------------------------------------------------------------

	function do_config( $action )
	{
		if ( $action=="load" ) load_config();
		if ( $action=="save" ) save_config();
	}

	function load_config()
	{

		if ( !file_exists(USER_CONFIG) ) die(json_encode(["code"=>404,"message"=>"No such file or directory"]));
		if ( !is_readable(USER_CONFIG) ) die(json_encode(["code"=>403,"message"=>"Permission denied"]));

		$data = @file_get_contents(USER_CONFIG) or die(json_encode(["code"=>204,"message"=>"Empty settings"]));

		preg_match_all( '/(^|#)(\w.*)="(.*)"/m', $data, $matched );
		$vars = array_combine( $matched[2], $matched[3] );
		$vars["HOSTNAME"] = $vars["HOSTNAME"] ?: "piview";

		preg_match_all('/card (\d+).*\[(.*)\],/', shell_exec('sudo arecord -l'), $cards );
		$vars["SOUNDCARDS"] = @array_combine( $cards[1], $cards[2] );

		print json_encode( $vars );
	}

	function save_config()
	{
		$temp = !is_writable( USER_CONFIG );
		$file = !$temp ? USER_CONFIG : tempnam(sys_get_temp_dir(),'piview-'); 

		if ( !is_readable(DEFAULT_CONFIG) ) die(json_encode(["code"=>403,"message"=>"Permission denied"]));
		
		$data = @file_get_contents(DEFAULT_CONFIG);
		foreach( $_POST as $key=>$value ) {
			$data = preg_replace("/(^|#)$key(\s+)?=.*$/m", "$key=\"$value\"", $data );
		}

		remote_update( $_POST );

		$handle = fopen( $file, "w" );
		if ( $handle ) {
			fwrite( $handle, $data );
			fclose( $handle );
		}

		if ( $temp ) system( "sudo /usr/bin/cp $file ".USER_CONFIG );
		system( "sudo /root/bin/audio.sh --setup" );

		print json_encode(["code"=>200,"message"=>"saved"]);
	}

	function parse_config()
	{
		$config = @file_get_contents(USER_CONFIG);
		$config = preg_replace( "/#.*/", "", $config );
		
		return parse_ini_string($config);
	}




	# ------------------------------------------------------------------------------------------------------------------
	#	STREAM
	# ------------------------------------------------------------------------------------------------------------------

	function do_log()
	{
		$log = shell_exec("sudo systemctl status -n 20 ".STREAM_SERVICE);
		preg_match("/.*Active:(.*)/i", $log, $matched );


		// check for error
		if ( $log ) {
			if ( preg_match("/failed to write buffer data/i", $log) ) {
				$matched[1] = "internal error";
				do_service( "stop" );
			}
			if ( preg_match("/no command lines found/i", $log) ) {
				$matched[1] = "command not found";
			}
		}
		else $matched[1] = $log = "Service not found: ".STREAM_SERVICE;



		// get system load average
		$cpu = array( "tot"=>0, "bin"=>array() );
		$cmd = script_command();
		if ( $cmd['bin'] ) foreach( $cmd['bin'] as $key=>$value) {
			$percent = trim(shell_exec( "ps -C $value -o %cpu | sed -n 2p" ))?:0;
			$cpu['tot'] += $percent;
			array_push( $cpu['bin'], "$value: $percent%" );
		}

		// get network traffic
		$net   = nettraffic( "eth0" );
		$temp  = shell_exec( "/opt/vc/bin/vcgencmd measure_temp" );
		$volts = shell_exec( "/opt/vc/bin/vcgencmd measure_volts core" ); 

		$info = sprintf(
			"average CPU usage ... %s".
			"\nprocess CPU usage ... %s".
			"\ntotals upload ....... %s".
			"\ntotals download ..... %s".
			"\ntemperatures ........ %s°c".
			"\ncore voltages ....... %sv".
			"\n",
			"${cpu['tot']}%", implode(", ",$cpu['bin']),
			$net['tx'], $net['rx'],
			preg_replace("/[^0-9\.]/","",$temp),
			preg_replace("/[^0-9\.]/","",$volts)
		);


		print json_encode([
			"message" => $matched[1],
			"active"  => stripos($matched[1],"running")!==false,
			"log" 	  => $log,
			"info"    => $info
		]);
	}

	function do_script( $action )
	{
		if ( $action=="load" ) print json_encode( script_command() );
		if ( $action=="save" ) script_save();
	}

	function script_command()
	{
		if ( !file_exists(STREAM_SCRIPT) ) return ["code"=>404,"message"=>"No such file or directory: ".STREAM_SCRIPT];
		if ( !is_readable(STREAM_SCRIPT) ) return ["code"=>403,"message"=>"Permission denied: ".STREAM_SCRIPT];

		$bash = @file_get_contents( STREAM_SCRIPT );
		$cmd  = array();

		if ( $bash && preg_match("/CMD=\"(.*)\"/",$bash,$matched) ) {
			$cmd['full'] = $matched[1];
			$cmd['cmd']  = preg_split( "/\s+\|\s+/", $matched[1], -1, PREG_SPLIT_NO_EMPTY );
			$cmd['bin']  = array();
			foreach( $cmd['cmd'] as $key=>$value ) array_push( $cmd['bin'], current(explode(' ',$value)) );
		}

		return $cmd['full'] ? $cmd : ["code"=>204,"message"=>"Empty commands"];
	}

	function script_save()
	{
		$temp = !is_writable( STREAM_SCRIPT );
		$file = !$temp ? STREAM_SCRIPT : tempnam(sys_get_temp_dir(),'piview-'); 

		if ( !is_readable(DEFAULT_SCRIPT) ) die(json_encode(["code"=>403,"message"=>"Permission denied"]));
		
		$content = @file_get_contents(DEFAULT_SCRIPT);
		$content = str_replace("CMD=\"\"", "CMD=\"".implode(" | ",$_POST['command'])."\"", $content );

		$handle = fopen( $file, "w" );
		if ( $handle ) {
			fwrite( $handle, $content );
			fclose( $handle );
		}

		if ( $temp ) system( "sudo /usr/bin/cp $file ".STREAM_SCRIPT );

		print json_encode(["code"=>200,"message"=>"saved"]);
	}




	# ------------------------------------------------------------------------------------------------------------------
	#	NETWORK
	# ------------------------------------------------------------------------------------------------------------------

	function do_netinfo()
	{
		print json_encode([
			"eth"    => netstatus("eth0"),
			"remote" => array(
				"ip" => @file_get_contents("http://pi.ubaa.net/ip"),
				"port" => remote_port()
			)
		]);
	}

	function netaddress()
	{
		return array(
			"lan"  => trim(shell_exec("hostname -i")),
			"wan"  => @file_get_contents("http://pi.ubaa.net/ip")
		);
	}

	function netstatus( $link, $list=false )
	{
		$status  = shell_exec("networkctl status $link");
		
		preg_match("/^\s+state: (.*)/im", $status, $state );
		preg_match("/^\s+address: (.*)/im", $status, $address );
		preg_match("/\sdns: (.*)\s+(.*)/im", $status, $dns );
		preg_match("/^\s+model: (.*)/im", $status, $model );

		$dns = $dns[1][0] ? $dns[2] ? $dns[1]."/".$dns[2] : $dns[1] : "";

		if ( !$list ) return sprintf(
			"state: %s\naddress: %s%s%s",
			$state[1], $address[1], $dns ? "\nDNS: ".$dns:"", $traffic?"\n$traffic":""
		);

		return array(
			"model" => $model[1],
			"state" => $state[1],
			"address" => $address[1],
			"DNS" => $dns
		);
	}

	function nettraffic( $link )
	{
		$ifconfig = shell_exec("ifconfig $link");

		preg_match("/^\s+RX packets.*\((.*)\)/im", $ifconfig, $rx );
		preg_match("/^\s+TX packets.*\((.*)\)/im", $ifconfig, $tx );

		return $rx||$tx ? array("tx"=>$tx[1],"rx"=>$rx[1]) : false;
	}

	function remote_update( $data )
	{
		$ini = parse_config();
		if ( $ini &&
			 $ini['REMOTE_ACCESS']!=$data['REMOTE_ACCESS'] || 
			($ini['REMOTE_ACCESS']=="yes" && $ini['REMOTE_ACCESS_HTTP_PORT']!=$data['REMOTE_ACCESS_HTTP_PORT']) || 
			($ini['REMOTE_ACCESS']=="yes" && $ini['REMOTE_ACCESS_SSH_PORT'] !=$data['REMOTE_ACCESS_SSH_PORT'])
		){
			$todo = $data['REMOTE_ACCESS']=="no" ? "stop" : "start";
			shell_exec( "sudo ".CONFIG_SCRIPT." --remote $todo" );
		}
	}

	function remote_port()
	{
		$data = parse_config();

		if ( $data['REMOTE_ACCESS']=="yes" ) {
			$status = shell_exec("sudo iptables -t nat -n -L");
			preg_match( "/.*tcp dpt:(\d+) redir ports 80/", $status, $HTTP );
			preg_match( "/.*tcp dpt:(\d+) redir ports 22/", $status, $SSH );

			if ( $HTTP || $SSH ) return array(
				"http" => $HTTP[1],
				"ssh"  => $SSH[1],
			);
			else {
				$message = shell_exec("sudo ".CONFIG_SCRIPT." --remote scan 2>&1");
				if ( !$message ) $message = "Unable to found remote access configuration !";
				return ["code"=>204,"message"=>$message];
			}
		}

		return false;
	}




	# ------------------------------------------------------------------------------------------------------------------
	#	SYSTEM
	# ------------------------------------------------------------------------------------------------------------------

	// function do_loadfile( $file )
	// {
	// 	if ( !file_exists($file) ) die( "No such file or directory: $file" );
	// 	if ( !is_readable($file) ) die( "Permission denied: $file" );

	// 	print @file_get_contents($file);
	// }

	function do_exec( $cmd, $quiet=false )
	{
		$cmd = escapeshellcmd($cmd);
		if ( $quiet ) exec( "$cmd &" );
		else print json_encode([
			"cmd" => $cmd,
			"result" => shell_exec( $cmd.' 2>&1' )
		]);
	}

	function do_reboot()
	{
		do_service("stop");
		system("sudo /usr/bin/systemctl reboot -i");
		sleep(10);
		print "reboot failed !";
	}

	function do_shutdown()
	{
		do_service("stop");
		system("sudo /usr/bin/systemctl poweroff -i");
		sleep(10);
		print "shutdown failed !";
	}

	function do_service( $unit_cmd, $unit=STREAM_SERVICE )
	{
		system( "sudo systemctl $unit_cmd $unit" );
	}

	function do_sysinfo()
	{

		$version = shell_exec( "grep -E \"^#\s+version:\" ".DEFAULT_CONFIG." | cut -d: -f2" );
		$net = netaddress();

		$cpu = shell_exec("cat /proc/cpuinfo");
		preg_match("/^model name\s+: (.*)/im", $cpu, $proc);
		preg_match("/^(ARMv\d+)/i", $proc[1], $arch);

		// http://elinux.org/RPi_HardwareHistory#Board_Revision_History
		$model = shell_exec("cat /proc/cpuinfo | grep 'Revision' | awk '{print $3}' | sed 's/^1000//'");
		switch( trim($model) ) {
			case "Beta"   : $name = "Model B (beta)"; break;
			case "0002"   : 
			case "0003"   : $name = "Model B Revision 1.0"; break;
			case "0004"   : 
			case "0005"   : 
			case "0006"   : $name = "Model B Revision 2.0"; break;
			case "0007"   : 
			case "0008"   : 
			case "0009"   : $name = "Model A Revision 2.0"; break;
			case "000d"   : 
			case "000e"   : 
			case "000f"   : $name = "Model B Revision 2.0"; break;
			case "0010"   : $name = "Model B+ Revision 1.0"; break;
			case "0011"   :
			case "0014"   : $name = "Compute Module"; break;
			case "0012"   : 
			case "0015"	  : $name = "Model A+ Revision 1.1"; break;
			case "0013"   : $name = "Model B+ Revision 1.2"; break;
			case "a01040" : $name = "2 Model B Revision 1.0"; break;
			case "a01041" : 
			case "a21041" : $name = "2 Model B Revision 1.1"; break;
			case "a22042" : $name = "2 Model B Revision 1.2"; break;
			case "900021" : $name = "Model A+ Revision 1.1"; break;
			case "900092" : $name = "Model Zero Revision 1.2"; break;
			case "900093" : 
			case "920093" : $name = "Model Zero Revision 1.3"; break;
			case "a02082" : 
			case "a22082" : $name = "3 Model B Revision 1.2"; break;
			default: $name = "unknown"; break;
		}


		$mem = shell_exec("free -h");
		preg_match("/mem:\s+(\d+M)/Ui", $mem, $memory);


		printf(
			"piview version ....... %s (%s)".
			"\nnetwork node name .... %s".
			"\nlocal address ........ %s".
			"\npublic address ....... %s".
			"\noperating system ..... %s".
			"\nkernel ............... %s".
			"\nprocessor ............ %s".
			"\nboard version ........ %s".
			"\ntotal memory ......... %s".
			"\n",
			trim($version), strtolower($arch[1]),
			uname('n'), $net['lan'], $net['wan'],
			uname('o'), uname('srv'),
			$proc[1], $name, $memory[1]
		);
	}

	function uname( $opt )
	{
		return trim( shell_exec("uname -$opt") );
	}

?>
