/**
 * (./) piview.js
 * (by) cousot stéphane @ http://www.ubaa.net/
 * (cc) some right reserved
 *
 *
 * User interaction, request/response dispatcher, frontend process.
 * version 0.1
 *
 * -------------------------------------------------------------------------------------------------
 *
 *  THIS CODE ARE RELEASED UNDER A CREATIVE COMMONS ATTRIBUTION 4.0 INTERNATIONAL LICENSE
 *  @ http://creativecommons.org/licenses/by/4.0/
 *
 * -------------------------------------------------------------------------------------------------
 */


const FETCH_STATUS_INTERVAL = 60*1000;
const AJAX_TIMEOUT_DELAY 	= 20*1000;
const AJAX_PING_FREQ 		= 7*1000;
const PANEL_TOGGLE_DURATION = 400;
const FADEOUT_OK_DELAY   	= 1600;
const FADEOUT_ERR_DELAY  	= 6000;

const ROI_PATTERN  = / --roi ([0-9\.,]+)/;
const ROI_PRECISON = 3;
const CGI  = "php/process.php";




$(document).ready(function()
{
	// stop propagation 
	$("a[href='#']").click(function(event){ event.preventDefault(); });

	// add toggle panel
	$("h2").click(function(e)
	{
		var $elem = $(this);

		if ( $elem.data('onopen') && $elem.siblings(".subpanel").is(":hidden") ) 
			eval( $elem.data('onopen')+'();' );
		if ( $elem.data('onclose') && !$elem.siblings(".subpanel").is(":hidden") ) 
			eval( $elem.data('onclose')+'();' ); 

		$(this).siblings(".subpanel").slideToggle( PANEL_TOGGLE_DURATION, function()
		{
			if ( $elem.data('oncomplete') && !$(this).is(":hidden") )
				eval( $elem.data('oncomplete')+'();' ); 
		});
		$(this).toggleClass("open");
	});

	// load preview image
	refreshPreview();

	// update UI
	audioinit();
	initScript();
	initRoi();

	// load
	loadSettings();
	loadScript();
	log();
});


/// SETTINGS ///////////////////////////////////////////////////////////////////////////////////////////////////////////

function loadSettings()
{
	$.ajax(
	{
		url: CGI,
		data: { do:"config",action:"load" },
		type: "POST",
		dataType: "json",
		timeout: AJAX_TIMEOUT_DELAY
	})
	.done(function(data)
	{

		//var $elem   = $("#settings");
		var $elem   = $(document);
		var $alert  = $("#settings .alert");
		//var $submit = $("#settings .submit");
		var $submit = $(".submit");

		if ( data.code ) $alert.addClass("error").text( "error: "+data.message ).show();

		if ( data.STATIC_ADDRESS ) $('#hostip').val( data.STATIC_ADDRESS );
		if ( data.HOSTNAME ) $('#hostname').val( data.HOSTNAME + ".local" );

		for( var p in data ) {
			switch(p) {
				case 'REMOTE_ACCESS' :
				case 'CIRRUS_HEADPHONE' :
				case 'CIRRUS_LINE_OUT' :
				case 'CIRRUS_SPEAKER' :
				case 'CIRRUS_SPDIF_OUT' :
					$elem.find("input[name='"+p+"']").prop('checked', data[p]=='yes');
					break;
				case 'CIRRUS_INPUT' :
					$("input[name='CIRRUS_INPUT'][value='"+data.CIRRUS_INPUT+"']").prop('checked', true).trigger('click');
					break;
				case 'SOUNDCARDS' :
					var i = 0;
					$.each( data[p], function(key,value) {
						if ( value=="snd_rpi_wsp") $(".cirrus").toggle();
						if ( value=="Blue Icicle") $(".blueicicle").toggle();
					});
					break;
				default:
					$elem.find("input[name='"+p+"']").val( data[p] );
					break;
			}
		}

		$('input.gain').trigger('input');

		$elem.find(":input")
		.keyup(function(){  $submit.show(); })
		.change(function(){ $submit.show(); });

		$alert.fadeOut( data.code ? FADEOUT_ERR_DELAY : FADEOUT_OK_DELAY );

	});
}

// save settings
function saveSettings()
{
	
	//var $elem   = $("#settings");
	var $elem   = $(document);
	var $alert  = $("#settings .alert");
	//var $submit = $("#settings .submit");
	var $submit = $(".submit");
	var address = $elem.find( "input[name='STATIC_ADDRESS']" ).val();
	var host    = $elem.find( "input[name='HOSTNAME']" ).val();

	// validate
	if ( $.trim(address) && !address.match(/^(\d{1,3}\.){3}\d{1,3}$/) ) {
		dialog( "INVALID STATIC ADDRESS", {
			message: "Please match the requested format (e.g. 192.168.0.2)"
		});
		return;
	}
	if ( !$.trim(host) ) {
		dialog("hostname could not be empty");
		return;
	}
	if ( !host.match(/^[a-zA-Z]+[\w\-]+\w+$/) ) {
		dialog( "INVALID HOSTNAME", {
			message: "Please match the requested format.\nRead the documentation for more information."
		});
		return;
	}


	// send data
	$submit.hide();
	$alert.removeClass("error").text("saving…").show();

	var data = { do:'config', action:'save' };
	$elem.find("input").each(function()
	{
		var type = $(this).attr("type");
		var name = $(this).attr("name");

		switch( type ) {
			case 'checkbox' : data[name] = $(this).is(':checked') ? 'yes' : 'no'; break;
			case 'radio' : if ($(this).is(':checked')) data[name] = $(this).val(); break;
			default: data[name] = $(this).val(); break;
		}
	});

	$.post( CGI, data, function(data)
	{
		if ( data.code==200 ) {
			$alert.text(data.message).fadeOut( FADEOUT_OK_DELAY );

			var ask = host+".local"!=$('#hostname').val();
			$('#hostname').val(host+".local");

			if ( ask ) dialog(
				"THE HOSTNAME HAS CHANGED", {
				message: "Your new hostname will be available the next boot.\nDo you want to reboot now ?",
				action: reboot,
				cancel: updateSettings
			});
			else updateSettings();

			netinfo();

		}
		else $alert.addClass("error").text("error: "+data.message).show().fadeOut(FADEOUT_ERR_DELAY);

	}, "json");
}

function updateSettings()
{

	var $elem = $("#settings");
	var addr  = $elem.find( "input[name='STATIC_ADDRESS']" ).val();

	var ask = addr!=$('#hostip').val();
	$('#hostip').val(addr);


	if ( ask ) dialog(
		"THE NETWORK ACCES WILL CHANGED", {
		message: "Do you want to update your network configuration now and reload this page ?",
		action: function()
		{
			dialog( "<a href='http://"+window.location+"'>updating</a> … wait", { class:'wait', action:false } );
			$.ajax({
				type: "POST",
				url: CGI,
				data: { do:"update" },
				timeout: 7000
			})
			.done( function(){ window.location.reload(); } )
			.fail( function()
			{
				var timer = setInterval(
					function()
					{
						$.ajax({ url: window.location, type: "HEAD", crossDomain: true })
						.done( function(result) { window.location.reload(); });
					},
					AJAX_TIMEOUT_DELAY
				);
			});
		}
	});
}






/// STATUS /////////////////////////////////////////////////////////////////////////////////////////////////////////////

// stream status
var log_t = null;
function log()
{
	$("#status .alert").text("refresh status…").removeClass("error");

	$.ajax({
		type: "POST",
		url: CGI,
		data: { do:"log" },
		timeout: AJAX_TIMEOUT_DELAY,
		dataType: "json"
	})
	.done(function(data)
	{
		$("#dialog").fadeOut();
		$("#status .alert").text(data.message).toggleClass("error",!data.active);
		$("#status .log").text(data.log);
		$("#status .info").text(data.info);
	})
	.fail( function()
	{
		dialog(
			'<a href="./">Your Raspberry PI</a> is not responding',{
			message : 'Please check your network connection, '+
			'cables, devices, (etc.), and wait a moment '+
			'before rebooting.',
			action: false
		});
	});
}

function startlogs()
{
	if ( !log_t ) log_t = setInterval( log, FETCH_STATUS_INTERVAL );
}

function stoplogs()
{
	if ( log_t ) {
		clearInterval(log_t);
		log_t = null;
	}
}

// stream control
function streamctl( action )
{
	$("#status .alert").removeClass("error").text(action+" wait…");
	$.post( CGI, {do:"service",ctl:action}, log );
}

function netinfo()
{
	
	$("#settings .alert").text("fecth info…").show();
	$.post( CGI, {do:"netinfo"}, function(data)
	{
		$("#settings .alert").fadeOut( FADEOUT_OK_DELAY );

		if ( data.eth ) $("#settings .info.eth").text(data.eth);
		if ( $("#settings").find("input[name='REMOTE_ACCESS']").is(':checked') ) {
			if ( data.remote.port.message ) $("#settings .info.remote").text( data.remote.port.message );
			else $("#settings .info.remote").text(
				"external interface address: http://"+data.remote.ip+":"+data.remote.port.http+"\n"+
				"external ssh access: ssh -p "+data.remote.port.ssh+" root@"+data.remote.ip
			);
		}
		else $("#settings .info.remote").text("");
		
	}, "json");
}






/// SCRIPT /////////////////////////////////////////////////////////////////////////////////////////////////////////////

function initScript()
{
	$("#script").find("input.cmd").keyup(function(e)
	{
		var code = e.which; // recommended to use e.which, it's normalized across browsers
		if ( code==13 ) {
			e.preventDefault();
			saveScript();
		}
		if ( code==27 ) {
			e.preventDefault();
			$(this).hide();
			$("#script").find("span[data-id='"+$(this).attr('id')+"']").show();
		}
	});
}

function loadScript()
{
	$.ajax(
	{
		url: CGI,
		data: { do:"script",action:"load" },
		type: "POST",
		dataType: "json",
		timeout: AJAX_TIMEOUT_DELAY
	})
	.done(function(data)
	{

		var $elem  = $("#script");
		var $alert = $("#script .alert");

		if ( data.code ) $alert.addClass("error").text( "error: "+data.message ).show();

		$elem.find("span.input").dblclick(function()
		{
			$(this).hide();
			$('#'+$(this).data('id')).val( $(this).text() ).show();
		})
		.css('font-family',$('input').css('font-family'))
		.css('font-size',$('input').css('font-size'))
		.show();
		
		$elem.find("input.cmd").val("").hide();

		$("#script .info").text( data.full );
		if ( data.bin ) for( var i=0; i<data.bin.length; i++ ) {
			var $span = $elem.find("span[data-id='"+data.bin[i]+"']");
			if ( $span.length ) {
				$span.text( data.cmd[i] );
				$('#'+data.bin[i]).val( data.cmd[i] );
			}
			else {
				$elem.find("span[data-id='pipe']").text( data.cmd[i] );
				$('#pipe').val( data.cmd[i] );
			}
		}

		$alert.fadeOut( data.code ? FADEOUT_ERR_DELAY : FADEOUT_OK_DELAY );

	});
}

function saveScript()
{
	var $elem  = $("#script");
	var $alert = $("#script .alert");
	
	$alert.removeClass("error").text("updating script…").show();

	var data = { do:"script", action:"save", command:[] };
	$elem.find("input.cmd").each(function()
	{
		var cmd = $.trim($(this).val());
		if ( cmd ) data.command.push( cmd );
	});

	$.post( CGI, data, function(data)
	{
		if ( data.code==200 ) {
			$alert.text(data.message).fadeOut( FADEOUT_OK_DELAY );
			loadScript();
		}
		else $alert.addClass("error").text("error: "+data.message).show().fadeOut(FADEOUT_ERR_DELAY);

	}, "json");
}

function initRoi()
{

	$('#roi canvas')
	.mousedown(function(e)
	{
		e.preventDefault();

		var offset = $(this).offset();
		var x  = e.pageX - offset.left;
		var y  = e.pageY - offset.top;
		var nx = ( x / $(this).get(0).width  ).toFixed(ROI_PRECISON);
		var ny = ( y / $(this).get(0).height ).toFixed(ROI_PRECISON);
		
		$(this).data('obj', { norm: [nx,ny], offset:[x,y], save:false } );
		$(this).data('roi', nx+","+ny+",0,0" );

	})
	.mousemove(function(e)
	{
		e.preventDefault();

		var roi = $(this).data('obj');
		if ( roi ) {

			var offset = $(this).offset();
			var w = ((e.pageX - offset.left - roi.offset[0]) / $(this).get(0).width).toFixed(ROI_PRECISON);
			var h = ((e.pageY - offset.top - roi.offset[1]) / $(this).get(0).height).toFixed(ROI_PRECISON);
			
			$(this).data('roi', roi.norm[0]+","+roi.norm[1]+","+Math.max(0,w)+","+Math.max(0,h) );
			roi.save = true;
			updateRoi();
		}
	})
	.mouseup(function(e)
	{
		e.preventDefault();
		var roi = $(this).data('obj');
		if ( roi && roi.save ) saveRoi();
		$(this).data('obj','');
	});
}

function openRoi()
{
	overlay('#roi');

	var $canvas = $('#roi canvas');
	var width   = $canvas.data('width');
	var height  = $canvas.data('height');
	var wwidth  = window.innerWidth  - parseInt($('#roi > div').css('padding-left'))*2;
	var wheight = window.innerHeight - parseInt($('#roi > div').css('padding-top'))*2 - $('#roi p').height() - parseInt($('#roi p').css('margin-bottom'));
	var prop    = width / height;
	var match   = ROI_PATTERN.exec( $('#raspivid').val() );

	height = wheight - 60;
	width  = height * prop;
	
	if ( width > wwidth ) {
		width  = wwidth - 60;
		height = width / prop;
	}

	$canvas.get(0).width  = parseInt(width);
	$canvas.get(0).height = parseInt(height)
	$canvas.data('roi', match ? match[1] : "0,0,1,1" ).data('obj','');

	$('#roi > div').css( 'left', (wwidth-width)/2+'px' );
	$('#roi > div').css( 'top', (wheight-height)/2+'px' );

	updateRoi();
}

function saveRoi()
{
	var roi = $('#roi canvas').data('roi');
	var cmd = $('#raspivid').val();
	cmd = cmd.replace( ROI_PATTERN, '' );
	if ( roi!="0,0,1,1" ) cmd = cmd.replace( 'raspivid', 'raspivid --roi '+roi );

	$('#raspivid').val( cmd );
	$("#script").find("span[data-id='raspivid']").text( cmd );

	saveScript();
}

function updateRoi()
{
	var coords  = $('#roi canvas').data('roi').split(',');
	var canvas  = $('#roi canvas').get(0);
	var width   = canvas.width;
	var height  = canvas.height;
	var context = canvas.getContext("2d");

	context.drawRect=function(x,y,w,h)
	{
		x=parseInt(x)+0.50;
		y=parseInt(y)+0.50;

		this.strokeStyle = "#FF0000";
		this.strokeRect(x,y,w-1,h-1);
	}

	context.clearRect( 0, 0, width, height );
	context.drawRect( coords[0]*width, coords[1]*height, coords[2]*width, coords[3]*height );
}

function refreshPreview()
{
	var $canvas = $('#roi canvas');
	var img = new Image();

	img.onload = function() {
		$canvas.css("background-image", "url("+this.src+")" );
		$canvas.data('width', this.width );
		$canvas.data('height', this.height );
	}
	img.src = "/img/preview.jpg?uniq="+new Date().getTime();
}

function makePreview()
{
	exec( '/boot/live-stream -i', refreshPreview );
}

function clearRoi()
{
	$('#roi canvas').data('roi', "0,0,1,1");
	updateRoi();
	saveRoi();
}







/// SYSTEM /////////////////////////////////////////////////////////////////////////////////////////////////////////////

function sysclear()
{
	$('#system .info').html( '<img src="img/loading.png" width="24" class="loading"> system information …' );
}

function sysinfo()
{
	$.post( CGI, {do:"sysinfo"}, function(content){
		$('#system .info').text(content);
	}, "text" );
}

function exec( cmd, callback )
{
	$.post( CGI, {do:"exec","cmd":cmd}, function( data )
	{
		overlay('#console');
		$("#console .title").text( data.cmd );

		var pre = $("#console").find("pre");
		pre.text( data.result );
		if ( pre.height()>$(window).height()-120 ) pre.css( "height", $(window).height()-120 );
		else pre.css( "height", "auto" );
		pre.hide().slideDown();

	}, "json")
	.done( callback );
}

function shutdown()
{
	dialog( "shutdown…", { class:'wait', action:false } );
	
	$.ajax({
		type: "POST",
		url: CGI,
		data: { do:"shutdown" },
		timeout: AJAX_TIMEOUT_DELAY,
		dataType: "text"
	})
	.done(function(msg)
	{
		$("#dialog").fadeOut();
		$("#system .alert").text(msg).show();
	})
	.fail( function()
	{
		var host = $('#hostname').val();
		dialog( "<a href='http://"+host+"/'>"+host+"</a> is OFF", { class:'halt', action:false } );
		stoplogs();
	});
}

function reboot()
{

	var host = $('#hostname').val();
	dialog( "<a href='http://"+host+"/'>rebooting</a> … wait", { class:'wait', action:false } );
	stoplogs();
	
	var xhr = null;
	var timer = setInterval( function(){
		if ( xhr ) xhr.abort();
		xhr = $.ajax({
			url: "http://"+HOST+"/"+$("#config").attr("action"),
			type: "HEAD",
			crossDomain: true
		})
		.done( function() { window.location = "http://"+HOST+"/"; });
	},
	AJAX_PING_FREQ);

	$.post( CGI, {do:"reboot"}, function(msg)
	{
		if ( timer ) {
			clearInterval(timer);
			timer = null;
		}
		$("#dialog").fadeOut();
		$("#system .alert").text(msg).show();

	}, "text");
}




/// INTERFACE //////////////////////////////////////////////////////////////////////////////////////////////////////////

// open message in dialog window
// optionnal args : { class:*, message:*, action:*, cancel:* }
function dialog( title, args )
{
	if ( !title ) return;

	if ( typeof(args)!='object' ) args = {};
	if ( !args.class ) args.class = "warning";

	var content = "<p class='title'>" + title + "</p>";
	if ( args.message ) content += "<p class='message'>"+ ( args.message.replace(/\n/g,"<br>") ) +"</p>";

	// alert
	if ( typeof(args.action)=='undefined' ) {
		content += "<p class='action'>";
		content += "<input type='button' value='Ok' onclick=\"$('#dialog').fadeOut();\">";
		content += "</p>";
	}

	// confirm
	if ( typeof(args.action)=='function' ) {
		content += "<p class='action'>";
		content += "<input type='button' value='Cancel'>";
		content += "<input type='button' value='Ok'>";
		content += "</p>";
	}

	$("#dialog").html( "<div class='"+args.class +"'>"+content+"</div>" ).stop().show();
	$("#dialog").find("input[type='button']").each(function(i)
	{
		if ( !i ) $(this).focus().click(function(){$('#dialog').fadeOut();}).click(args.cancel);
		else $(this).click(function(){$('#dialog').fadeOut();}).click(args.action);
		$('#dialog > div').css("padding-bottom", 0);
	});
}

function toggle( elem, target )
{
	var m = $( elem ).text().match(/View|Hide/);
	var t = $( elem ).text().replace(/View|Hide/,'');
	$( target ).toggle();
	if ( m ) $( elem ).text( $(target).is(":hidden") ? "View"+t : "Hide"+t );
}

function overlay( target )
{
	$(target).addClass('overlay');
	$(target).show().click( function(e) { if ( e.target==this ) $(this).fadeOut(); });
}




// update audio input
function audioinit()
{

	// handle selected input default gain
	$( 'input[name=CIRRUS_INPUT]' ).click(function(){

		var pga = dig = 0;
		var hide = [];
		var mono = false;

		switch( $(this).val() ) {
			case "dmic"	   : dig = -6; hide = ['pga']; break;
			case "mic"	   : pga = 20; mono = true; break;
			case "linein"  : pga = 8; break;
			case "micbias" : pga = 20; break;
			case "spdifin" : hide = ['pga','dig']; break;
		}

		$('input[name=CIRRUS_INL_VOL]').val(0).trigger('input');
		$('input[name=CIRRUS_INR_VOL]').val(0).trigger('input');
		$('input[name=CIRRUS_INL_PGA]').val( pga ).trigger('input');
		$('input[name=CIRRUS_INR_PGA]').val( pga ).trigger('input');
		$('input[name=CIRRUS_INL_DIG]').val( dig ).trigger('input');
		$('input[name=CIRRUS_INR_DIG]').val( dig ).trigger('input');

		$('#cirrus span.inl').toggleClass( 'hide', mono );
		if ( mono ) $('#cirrus span.inr').toggleClass( 'hide', false );
		else {
			$('#cirrus span.pga').toggleClass( 'hide', $.inArray('pga',hide)!=-1 );
			$('#cirrus span.dig').toggleClass( 'hide', $.inArray('dig',hide)!=-1 );
		}

	});

	// add slider output value
	// value to DB  = ( value-(Math.abs(min)/step) )*step
	// DB to value  = ( value+Math.abs(min) ) / step
	$('input.gain').each(function(){
		$(this).parent().attr( 'class', $(this).attr('class') );
		$(this).after( '<span id="'+$(this).attr('name')+'" class="gain"></span>' );
		$(this).on('input',function(){
			var val = parseFloat( $(this).val() );
			var sign = val==0 ? ' ' : (val<0 ? '-' : '+');
			$('#'+$(this).attr('name')).text( sign+' '+Math.abs($(this).val()).toFixed(2)+' dB' );
		});
	});
}

// test audio card
function audiotest(what)
{
	$.ajax({
		url: CGI,
		data: {"do":"exec","cmd":"sudo /root/bin/audio.sh --test "+what},
		type: "POST",
		dataType: "text",
		timeout: 3000,
	})
	.done(function(msg)
	{
		if ( msg ) dump(msg);
		$("#audio_resp").removeClass("warning").fadeOut( FADEOUT_OK_DELAY );
	});

	if ( what=="stop"  ) $("#audio_resp").removeClass("warning").fadeOut( FADEOUT_OK_DELAY );
	else $("#audio_resp").html("running test <span class=\"running\"></span>").addClass("warning").show();
}
