<?php

	$HOSTNAME = preg_replace( "/\.local/", "", $_SERVER['SERVER_NAME'] );

	// handle request: only the first request
	// see php/process.php for more details
	if ( $_REQUEST ) {
		$keys = array_keys( $_REQUEST );
		header( "location: ./${keys[0]}" );
	}


?>
<!DOCTYPE html>
<html>
	<head>
		<meta charset="utf-8">
		<title><?= $HOSTNAME ?> - admin</title>
		<meta name="viewport" content="width=device-width, initial-scale=1">
		<link rel="icon" href="img/icon.png">
		<link rel="stylesheet" href='css/piview.css'>
		<link rel="stylesheet" href="css/mobile.css" media="screen and (max-device-width: 780px)">
		<script src="js/jquery-3.1.1.min.js"></script>
		<script src="js/piview.js"></script>
	</head>

	<body>
		<div id="container">
			<h1><?= $HOSTNAME ?> <img src="img/icon.png" width="32" alt=""> Admin</h1>

			<!-- network panel -->
			<div id="settings" class="panel">
				<h2 data-onopen="netinfo">Network Configuration</h2>
				<div class="alert">Loading settings…</div>
				<a href="#" class="submit" onclick="saveSettings();">save</a>
				<div class="subpanel">
					<h3>Ethernet</h3>
					<div class="setting">
						<p class="doc">
							Enter a valid static address or leave blank to use DHCP.<br>
							For IPv6 static address, DNS or gateway configuration, edit the profile manually: <em>/etc/systemd/network/eth0.network</em><br>
							More informations at <a href="https://wiki.archlinux.org/index.php/Systemd-networkd">systemd-networkd documentation</a>
						</p>
						<p class="var">
							<input id="hostip" type="hidden" />
							<label>static address</label>: <input name="STATIC_ADDRESS" value="" pattern="^(\d{1,3}\.){3}\d{1,3}$">
						</p>
						<pre class="info eth"></pre>
					</div>
					<h3>Hostname</h3>
					<div class="setting">
						<p class="doc">
							Specify the hostname for this RPI.
							<br>
							The HOSTNAME should be an internet-style hostname, only the ASCII letters 'a' through 'z' (in a case-insensitive manner, lower case is safer), the digits '0' through '9', and the hyphen ('-'). No other symbols, punctuation characters, or white space are permitted.<br>
							The original specification (RFC 952) mandated that hostnames could not start with a digit or with a hyphen, and must not end with a hyphen.<br>
							Limit the hostname to 63 characters, which is the length of a DNS label.<br>
							For examples, <a href="http://www.freedesktop.org/wiki/Software/systemd/hostnamed/">read the end of this documentation</a>
						</p>
						<p class="var">
							<input id="hostname" type="hidden" />
							<label>hostname</label> : <input name="HOSTNAME" value="<?= $HOSTNAME ?>" maxlength="63" pattern="^[a-zA-Z]+[\w\-]+\w+$">
						</p>
					</div>
					<h3>Remote access</h3>
					<div class="setting">
						<p class="doc">
							Enable this service to configure and access your stream box remotely.<br>
							To map a particular port on your router, enter the appropriate HTTP and/or SSH port in fields below, or leave blank to use a random port number.<br>
							<em>note: UPnP must be activated on your router to open automatically NAT/PAT rules.</em>
						</p>
						<p class="var">
							<input name="REMOTE_ACCESS" type="checkbox" value="yes"> turn on remote access service on boot<br>
							<label>HTTP port</label>: <input name="REMOTE_ACCESS_HTTP_PORT" value=""><br>
							<label>SSH port</label>:  <input name="REMOTE_ACCESS_SSH_PORT" value="">
						</p>
						<pre class="info remote"></pre>
					</div>
				</div>
			</div>

			<!-- script configuration -->
			<div id="script" class="panel">
				<h2>Script Configuration</h2>
				<div class="alert">Loading script…</div>
				<div class="subpanel">
					<h3>Camera (raspivid)</h3>
					<div class="setting">
						<p class="doc">
							Double-click to edit, ENTER to save, ESC to cancel.<br>
							Leave blank to access the camera module from another bin using <em>/dev/video0</em>.
						</p>
						<p class="var">
							<span data-id="raspivid" class="cmd input"></span>
							<input id="raspivid" class="cmd">
						</p>
						<p>
							<a href="#" onclick="openRoi();">Set region of interest</a><br>
							<a href="#" onclick="toggle(this,'#standard');">View size/bitrate standard</a><br>
							<code id="standard" class="doc hide">
								SD Low &nbsp; &nbsp;: -w 480 -h 260 -fps 25 -b 800000<br>
								SD Medium : -w 640 -h 360 -fps 25 -b 1200000<br>
								SD High &nbsp; : -w 960 -h 540 -fps 25 -b 1800000<br>
								HD Ready &nbsp;: -w 1280 -h 720 -fps 25 -b 2500000<br>
								Full HD &nbsp; : -w 1920 -h 1080 -fps 25 -b 5000000
							</code>
							<a href="#" onclick="toggle(this,'#man');">View man raspivid</a>
							<code id="man" class="doc hide">
								<?php
									$man = shell_exec("raspivid");
									print nl2br( str_replace(",",", ",$man) );
								?>
							</code>
						</p>
					</div>
					<h3>Stream configuration</h3>
					<div class="setting">
						<p class="doc">
							Double-click to edit, ENTER to save, ESC to cancel.<br>
							Leave blank means no pipe, use the command above.
						</p>
						<p class="var">
							<span data-id="pipe" class="cmd input"></span>
							<input id="pipe" class="cmd">
						</p>
					</div>
					<pre class="info cmd"></pre>
				</div>
			</div>

			<div id="status" class="panel">
				<h2 data-onopen="startlogs" data-onclose="stoplogs">Stream Status</h2>
				<div class="alert">refresh status…</div>
				<div class="subpanel">
					<p>
						<input type="button" value="start"   onclick="streamctl(this.value);">
						<input type="button" value="stop"    onclick="streamctl(this.value);">
						<input type="button" value="restart" onclick="streamctl(this.value);">
					</p>
					<pre class="info"></pre>
					<p>
						<a href="#" onclick="log();">Refresh status (or wait a minute)</a><br>
						<a href="#" onclick="toggle(this,'#status .log');">View log</a>
					</p>
					<pre class="log hide"></pre>
				</div>
			</div>

			<!-- audio panel -->
			<div class="panel">
				<h2>Audio Status</h2>
				<div id="audio_resp" class="alert"></div>
				<a href="#" class="submit" onclick="saveSettings();">save</a>
				<div class="subpanel">
					<p>
						<span class="blueicicle hide">
							<a href="#" onclick="exec('sudo /root/bin/audio.sh --icicle status');return false;">Blue Icicle audio card status</a><br>
						</span>
						<span class="cirrus hide">
							<a href="#" onclick="exec('sudo /root/bin/audio.sh --cirrus status');return false;">Cirrus Logic/Wolfson audio card status</a><br>
						</span>
					</p>
					<h3 class="blueicicle hide">Blue Icicle setup</h3>
					<div id="blueicicle" class="setting blueicicle hide">
						<p class="var">
							<label class="gain">mic capture volume</label>: 
							<input type="range" name="BLUEICICLE_IN_GAIN" class="gain" min="-8" max="14" step="1" value="0">
						</p>
					</div>
					<h3 class="cirrus hide">Cirrus Logic/Wolfson audio card setup</h3>
					<div id="cirrus" class="setting cirrus hide">
						<p>
							Input :<br>
							<span class="doc">Only one input can be used for recording</span><br>
							<span class="doc">By selecting one input below, all gains will be resetted to their default values</span><br>
						</p>
						<p class="var">
							<input type="radio" name="CIRRUS_INPUT" value="dmic"><label>on board digital MEMS microphones</label><br>
							<input type="radio" name="CIRRUS_INPUT" value="mic"><label>mic (or headset input)</label><br>
							<input type="radio" name="CIRRUS_INPUT" value="linein"><label>line in</label><br>
							<input type="radio" name="CIRRUS_INPUT" value="micbias"><label>line in + bias voltage</label><br>
							<input type="radio" name="CIRRUS_INPUT" value="spdifin"><label>S\PDIF receiver</label>
						</p>
						<p class="var">
							<span>
								<label class="gain">audio interface volume (L)</label>: 
								<input type="range" name="CIRRUS_INL_VOL" class="gain inl" min="-32" max="16" step="1" value="0"><br>
							</span>
							<span>
								<label class="gain">audio interface volume (R)</label>: 
								<input type="range" name="CIRRUS_INR_VOL" class="gain inr" min="-32" max="16" step="1" value="0"><br>
							</span>
							<span>
								<label class="gain">input PGA gain (L)</label>: 
								<input type="range" name="CIRRUS_INL_PGA" class="gain inl pga" min="0" max="31" step="1" value="0"><br>
							</span>
							<span>
								<label class="gain">input PGA gain (R)</label>: 
								<input type="range" name="CIRRUS_INR_PGA" class="gain inr pga" min="0" max="31" step="1" value="0"><br>
							</span>
							<span>
								<label class="gain">digital input gain (L)</label>: 
								<input type="range" name="CIRRUS_INL_DIG" class="gain inl dig" min="-64" max="31.5" step="0.5" value="0"><br>
							</span>
							<span>
								<label class="gain">digital input gain (R)</label>: 
								<input type="range" name="CIRRUS_INR_DIG" class="gain inr dig" min="-64" max="31.5" step="0.5" value="0">
							</span>
						</p>
						<br>
						<p>
							Output :<br>
							<span class="doc">Multiple output can be selected</span>
						</p>
						<p class="var">
							<input name="CIRRUS_HEADPHONE" type="checkbox" value="yes"> headphone<br>
							<input name="CIRRUS_LINE_OUT" type="checkbox" value="yes"> line out<br>
							<input name="CIRRUS_SPEAKER" type="checkbox" value="yes"> speakers<br>
							<input name="CIRRUS_SPDIF_OUT" type="checkbox" value="yes"> S/PDIF transmitter
						</p>
					</div>
					<h3>Test input</h3>
					<p>
						Internal audio in to audio out.<br>
						<span class="doc">
							Select at least one output if you use any additional card.<br>
							Save your settings and stop streaming to free audio input.
						</span>
					<p>
					</p>
						<input type="button" value="start" onclick="audiotest(this.value);">
						<input type="button" value="stop"  onclick="audiotest(this.value);">
					</p>
				</div>
			</div>

			<!-- system panel -->
			<div id="system" class="panel">
				<h2 data-onopen="sysclear" data-oncomplete="sysinfo">System Management</h2>
				<div class="alert error"></div>
				<div class="subpanel">
					<pre class="info"></pre>
					<dl>
						<dt>USB</dt>
						<dd><a href="#" onclick="exec('lsusb');">List connected USB device</a></dn>
						<dt>Network</dt>
						<dd><a href="#" onclick="exec('networkctl');">List network link</a></dd>
						<dd><a href="#" onclick="exec('networkctl --all status');">Network status</a></dd>
						<dt>Video</dt>
						<dd><a href="#" onclick="exec('v4l2-ctl --list-devices');">List video devices</a></dd>
						<dt>Audio</dt>
						<dd><a href="#" onclick="exec('cat /proc/asound/cards');">List audio devices</a></dd>
						<dd><a href="#" onclick="exec('sudo arecord -l');">List capture device</a></dd>
						<dd><a href="#" onclick="exec('sudo aplay -l');">List playback device</a></dd>
					</dl>
					<p>
						<input type="button" value="reboot" onclick="reboot();">
						<input type="button" value="shutdown" onclick="shutdown();">
					</p>
				</div>
			</div>

			<!-- overlay -->
			<div id="roi" class="overlay">
				<div>
					<p>
						<a href="#" onclick="clearRoi();">Clear ROI</a><br>
						<a href="#" onclick="makePreview();">Refresh image</a>
					</p>
					<div class="canvas">
						<canvas></canvas>
						<span class="doc">click drag to select a region.</span>
					</div>
				</div>
			</div>
			<div id="console" class="overlay">
				<div>
					<p class="title"></p>
					<pre></pre>
					<input type="button" value="close" onclick="$('#console').fadeOut();">
				</div>
			</div>
			<div id="dialog" class="overlay">
				<img src="img/warning.png">
				<img src="img/halt.png">
				<img src="img/loading.png">
			</div>

		</div>
	</body>
</html>