#!/usr/bin/sh
#
# File: scheduler.sh
# Version: 0.1
# Authors: Stéphane Cousot <http://www.ubaa.net/>
# License: schedule.sh is released under GNU General Public License, version 3 or later
#
# ----------------------------------------------------------------------------------
#
# This file is part of the piview project.
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#


SERVICE='piview-livestream'


start()
{
	systemctl start $SERVICE
}

stop()
{
	systemctl stop $SERVICE
}

restart()
{
	if [ `systemctl is-active $SERVICE` == "active" ]; then
		systemctl restart $SERVICE
	fi
}




# ---------------------------------------------------------------------------------------------------------------------
#	MAIN FUNCTIONS
# ---------------------------------------------------------------------------------------------------------------------

usage()
{
	echo "$0 {COMMAND} ..."
	echo ""
	echo "piview schedule manager"
	echo 
	echo "  -h --help             show this help"
	echo "  --start|stop|restart  start, stop or restart the stream service"
}



if [[ -z "$1" || "$1" == "-h" ]]; then
	usage
	exit 1
fi


$1
exit $?
