π-view setup
============

* [Prepare the SD card]
* [Installation]
* [Configure network access]
* [Configure the web server]
* [Configure the camera module]
* [Configure audio]
  * [Add Cirrus Logic/Wolfson Audio Card support]
* [Finalize]
* [References]







Prepare the SD card
-------------------
Install ArchLinux ARM on SD card (4GB min.)  
**For high performance, a Raspberry Pi version 2 or later is required**.  
http://archlinuxarm.org/platforms/armv7/broadcom/raspberry-pi-2

Insert the SD card into the Raspberry Pi, connect ethernet, and apply 5V power.  
SSH to the IP address given to the board by your router and upgrade the system as *root*.
``` bash
# root is disabled by default, log in as alarm and switch to root
ssh alarm@192.168.x.x
# type `alarm` on password prompt and change to the target root's home directory
su -
# type `root` on password prompt
# set th image up-to-date
pacman -Syu
```

Optionally set the root password.
``` bash
# enter the new password at prompt
passwd
```







Installation
------------
Install dependencies
``` bash
pacman -S alsa-utils alsa-plugins alsa-firmware alsa-lib
pacman -S ffmpeg omxplayer
```

Download and extract the *'piview'* core files to the root directory.
``` bash
curl -A "fake-agent" http://piview.ubaa.net/piview-core.tar.gz | tar xvz -C /root
chmod +x ./bin/*.sh
```

Move π-view services to the systemd directories.
``` bash
mv ./usr/lib/systemd/system/*.service /usr/lib/systemd/system/
mv ./usr/lib/systemd/system/*.timer /usr/lib/systemd/system/
```







Configure network access
------------------------
Set the new hostname.  
By convention use *'piview'* for the sender and *'piplay'* for the receiver, but could be anything else.
``` bash
hostnamectl set-hostname piview
# or
hostnamectl set-hostname piplay
```

Install and configure the multicast Domain Name System or [mDNS](http://en.wikipedia.org/wiki/Multicast_DNS).
``` bash
# install packages
pacman -S avahi nss-mdns
# copy ssh services
mv ./etc/avahi/services/*.service /etc/avahi/services/
# enable the service on boot
systemctl enable avahi-daemon
```

Install dependencies for managing USB tethering.  
*notes: from an Androïd smartphone, connect the phone to your Raspberry Pi using an USB cable. Enable the tethering option from your phone settings, and use a network scan application to find your RPI address.*
``` bash
pacman -S usbmuxd libimobiledevice ifuse
```

Install dependencies to support remote access.
``` bash
pacman -S miniupnpc
```







Install the web server and configure
------------------------------------
Install the lighttpd and php packages from the official repositories.
``` bash
pacman -S lighttpd fcgi php-cgi
```


Configure the server.
``` bash
# open the server configuration file
nano /etc/lighttpd/lighttpd.conf
# add the following lines to allow lighttpd to handle 404 errordoc and cross-domain request.
# save and exit
server.error-handler-404   = "/php/process.php"
setenv.add-response-header = ("Access-Control-Allow-Origin" => "*")
server.modules            += ("mod_setenv")
```


Update Lighttpd configuration for FastCGI.
``` bash
# create a new directory
mkdir /etc/lighttpd/conf.d

# create a configuration file for fastCGI
nano /etc/lighttpd/conf.d/fastcgi.conf
# add the following lines, save and exit
server.modules   += ("mod_fastcgi")
index-file.names += ("index.php")
fastcgi.server    = ( 
    ".php" => (
        "localhost" => ( 
            "bin-path" => "/usr/bin/php-cgi",
            "socket" => "/tmp/php-fastcgi.sock",
            "broken-scriptfilename" => "enable",
            "max-procs" => 4,
            "bin-environment" => (
                "PHP_FCGI_CHILDREN" => "16"
            )
        )
    )
)
# link the fastCGI conf file
echo 'include "conf.d/fastcgi.conf"' >> /etc/lighttpd/lighttpd.conf
```


Add permissions to http (lighttpd user).
``` bash
# install sudo package
pacman -S sudo
# open sudoers file
EDITOR=nano visudo
# add the following lines, save and exit
http ALL=NOPASSWD: /usr/bin/systemctl
http ALL=NOPASSWD: /usr/bin/poweroff
http ALL=NOPASSWD: /usr/bin/reboot
http ALL=NOPASSWD: /usr/bin/cp
http ALL=NOPASSWD: /usr/bin/arecord
http ALL=NOPASSWD: /usr/bin/aplay
http ALL=NOPASSWD: /usr/bin/iptables
http ALL=NOPASSWD: /root/bin/audio.sh
http ALL=NOPASSWD: /root/bin/setup.sh
```


Modify some PHP configuration values.
``` bash
# open PHP configuration file
nano /etc/php/php.ini
# search for each configuration variable below (ctrl+W), modify, save and exit
# change 'error_reporting = E_ALL & ... ' to
error_reporting = E_ALL & ~E_NOTICE & ~E_STRICT
# Turn on the display of errors
display_errors = On
```


Move the web server files and change file owner
``` bash
mv ./srv/http/* /srv/http/
chown -R http:http /srv/http
```

Enable the server service on boot.
``` bash
systemctl enable lighttpd
```







Configure audio
---------------
Add a virtual two-channel device support
``` bash
mv ./etc/asound.conf /etc/asound.conf
``` 


### Add Cirrus Logic/Wolfson Audio Card support (optional)

Add repository named *wsp* to /etc/pacman.conf configuration file.
``` bash
# open pacman configuration file
nano /etc/pacman.conf
# add the following lines, save and exit
# !!! for the Cirrus Logic Audio Card only (Raspberry Pi >=2)
[wsp]
SigLevel = Never
Server = http://headless.audio/pkg/armv7h
# !!! for the Wolfson Audio Card only (Raspberry Pi models B, A+ and B+)
[wsp]
SigLevel = Never
Server = http://headless.audio/pkg/armv6h
```

Update packages database and install linux-raspberrypi-wsp package (linux-raspberrypi package replacement)
``` bash
pacman -Syu
pacman -S linux-raspberrypi-wsp
```

Enable onboard audio interface, Cirrus Logic/Wolfson card and mmap support.
mmap support is optional but required by JACK daemon.
``` bash
# open the config file
nano /boot/config.txt
# uncomment or add the follow lines, save and exit
# note: you may add the camera configuration again, see the [Configure the camera module] section
dtparam=audio=on
dtoverlay=i2s-mmap
dtoverlay=rpi-cirrus-wm5102
```







Configure the camera module
---------------------------
The commands for the camera module are included as part of the raspberrypi-firmware-tools package - which is installed by default but we must enable the camera module manually.
``` bash
# create symbolic links
ln -s /opt/vc/bin/raspivid /usr/bin
ln -s /opt/vc/bin/raspistill /usr/bin
# open the configuration file
nano /boot/config.txt
# append lines below, save and exit
gpu_mem=512
start_file=start_x.elf
fixup_file=fixup_x.dat
disable_camera_led=1
```






Finalize
--------
Add statically the initialization service.
``` bash
ln -s /usr/lib/systemd/system/piview-init.service /usr/lib/systemd/system/sysinit.target.wants/
```

Enable MOTD on boot
``` bash
systemctl enable piview-motd
```


Enable schedulers.
``` bash
systemctl enable piview-autorestart.timer
systemctl enable piview-autostart.timer
systemctl enable piview-autostop.timer
systemctl enable piview-monitor.timer
```


Copy the empty π-view script and configuration file on boot for people who want to edit this file manually on another computer. Notes: these files will be overrided (and create if not exists) each time you save your π-view settings from your web browser.
``` bash
cp /srv/http/conf/default /boot/settings.txt
cp /srv/http/conf/script /boot/live-stream
```

Clean.
``` bash
rm -r ./etc
rm -r ./srv
rm -r ./usr
```

Turn power off.
``` bash
poweroff
```







References
----------
http://elinux.org/ArchLinux_Install_Guide  
https://wiki.archlinux.org/index.php/Raspberry_Pi   
https://wiki.archlinux.org/index.php/Systemd#Using_units  
https://wiki.archlinux.org/index.php/lighttpd  
http://elinux.org/Rpi_Camera_Module  
http://headless.audio/







[top]: #user-content-π-view-setup  
[Prepare the SD card]: #user-content-prepare-the-sd-card  
[Installation]: #user-content-installation  
[Configure network access]: #user-content-configure-network-access  
[Configure the web server]: #user-content-install-the-web-server-and-configure  
[Configure the camera module]: #user-content-configure-the-camera-module  
[Configure audio]: #user-content-configure-audio  
[Add Cirrus Logic/Wolfson Audio Card support]: #user-content-add-cirrus-logicwolfson-audio-card-support-optional  
[Finalize]: #user-content-finalize  
[References]: #user-content-references  
